# number of instances per condition
n = 240

# two contrasts (three levels)
c1 = rep(c(0,1,0), n)
c2 = rep(c(0,0,1), n)
y = rnorm(n, mean=c1*1-2*c2, sd=1) 

cor(c1,c2)

# vif
library(Design)
d = data.frame(y= y, c1= c1, c2= c2)
l = ols(y ~ c1 + c2, d)
l
vif(l)

# fixed effect correlation
library(lme4)
npersubj = 24
d$Subject = as.factor(sort(rep(1:10,npersubj*3)))
summary(d)
lmer(y ~ c1 + c2 + (1 | Subject), d)

# three contrasts (four levels)
c1 = rep(c(0,1,0,0), n)
c2 = rep(c(0,0,1,0), n)
c3 = rep(c(0,0,0,1), n)

cor(c1,c2)
cor(c1,c3)
cor(c2,c3)

# unbalanced data set
c1 = rep(c(0,1,1,1,1,0,0,0,0), n)
c2 = rep(c(0,0,0,0,0,1,1,1,1), n)

cor(c1,c2)